<?php

namespace App\Filament\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\PostHistory;
use Filament\Resources\Resource;
use Tables\Columns\ActionColumn;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\PostHistoryResource\Pages;
use App\Filament\Resources\PostHistoryResource\RelationManagers;

class PostHistoryResource extends Resource
{
    protected static ?string $model = PostHistory::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('created_at')->label('Tanggal')->dateTime('d M Y, H:i')->sortable(),
                Tables\Columns\TextColumn::make('post_title')->label('Judul Postingan')->searchable()->limit(40),
                Tables\Columns\TextColumn::make('site.name')->label('Situs')->searchable()->sortable(),
                Tables\Columns\IconColumn::make('status')
                    ->icon(fn (string $state): string => match ($state) {
                        'Berhasil' => 'heroicon-o-check-circle',
                        'Gagal' => 'heroicon-o-x-circle',
                    })
                    ->color(fn (string $state): string => match ($state) {
                        'Berhasil' => 'success',
                        'Gagal' => 'danger',
                    }),
    
                // === BAGIAN YANG DIPERBAIKI ===
                Tables\Columns\TextColumn::make('post_url')
                    ->label('Link Postingan')
                    ->url(fn (string $state): string => $state) // Gunakan isi kolom (URL) sebagai link
                    ->openUrlInNewTab(), // Buka di tab baru
                // ============================
            ])
            ->defaultSort('created_at', 'desc');
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPostHistories::route('/'),
            'create' => Pages\CreatePostHistory::route('/create'),
            'view' => Pages\ViewPostHistory::route('/{record}'),
            'edit' => Pages\EditPostHistory::route('/{record}/edit'),
        ];
    }
}
